using System;
using System.Collections.Generic;
using System.Text;

namespace AllocsFixes.JSON
{
	public class JSONArray : JSONNode
	{
		private List<JSONNode> nodes = new List<JSONNode> ();

		public JSONNode this [int index] {
			get { return nodes [index]; }
			set { nodes [index] = value; }
		}

		public int Count {
			get { return nodes.Count; }
		}

		public void Add (JSONNode node)
		{
			nodes.Add (node);
		}

		public override void ToString (StringBuilder stringBuilder, bool prettyPrint = false, int currentLevel = 0)
		{
			stringBuilder.Append ("[");
			if (prettyPrint)
				stringBuilder.Append ('\n');
			foreach (JSONNode n in nodes) {
				if (prettyPrint)
					stringBuilder.Append (new String ('\t', currentLevel + 1));
				n.ToString (stringBuilder, prettyPrint, currentLevel + 1);
				stringBuilder.Append (",");
				if (prettyPrint)
					stringBuilder.Append ('\n');
			}
			if (stringBuilder.Length > 1)
				stringBuilder.Remove (stringBuilder.Length - (prettyPrint ? 2 : 1), 1);
			if (prettyPrint)
				stringBuilder.Append (new String ('\t', currentLevel));
			stringBuilder.Append ("]");
		}

		public static JSONArray Parse (string json, ref int offset)
		{
			//Log.Out ("ParseArray enter (" + offset + ")");
			JSONArray arr = new JSONArray ();

			bool nextElemAllowed = true;
			offset++;
			while (true) {
				Parser.SkipWhitespace (json, ref offset);

				switch (json [offset]) {
					case ',':
						if (!nextElemAllowed) {
							nextElemAllowed = true;
							offset++;
						} else
							throw new MalformedJSONException ("Could not parse array, found a comma without a value first");
						break;
					case ']':
						offset++;
						//Log.Out ("JSON:Parsed Array: " + arr.ToString ());
						return arr;
					default:
						arr.Add (Parser.ParseInternal (json, ref offset));
						nextElemAllowed = false;
						break;
				}
			}
		}

	}
}

