using System;
using System.Text;

namespace AllocsFixes.JSON
{
	public class JSONNull : JSONValue
	{
		public JSONNull ()
		{
		}

		public override void ToString (StringBuilder stringBuilder, bool prettyPrint = false, int currentLevel = 0)
		{
			stringBuilder.Append ("null");
		}

		public static JSONNull Parse (string json, ref int offset)
		{
			//Log.Out ("ParseNull enter (" + offset + ")");

			if (json.Substring (offset, 4).Equals ("null")) {
				//Log.Out ("JSON:Parsed Null");
				offset += 4;
				return new JSONNull ();
			} else {
				throw new MalformedJSONException ("No valid null value found");
			}
		}

	}
}

