using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Threading;
using System.Text;
using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers
{
	public class UserStatusHandler : PathHandler {
		public UserStatusHandler (string moduleName = null) : base(moduleName) {
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			JSONObject result = new JSONObject ();

			result.Add ("loggedin", new JSONBoolean (user != null));
			result.Add ("username", new JSONString (user != null ? user.SteamID.ToString () : string.Empty));

			JSONArray perms = new JSONArray ();
			foreach (WebPermissions.WebModulePermission perm in WebPermissions.Instance.GetModules ()) {
				JSONObject permObj = new JSONObject ();
				permObj.Add ("module", new JSONString (perm.module));
				permObj.Add ("allowed", new JSONBoolean (WebPermissions.Instance.ModuleAllowedWithLevel (perm.module, permissionLevel)));
				perms.Add (permObj);
			}
			result.Add ("permissions", perms);

			AllocsFixes.NetConnections.Servers.Web.API.WebAPI.WriteJSON (resp, result);
		}

	}

}

