using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers
{
	public class SessionHandler : PathHandler {
		private string staticPart;
		private Web parent;
		private string header = "";
		private string footer = "";

		public SessionHandler (string _staticPart, string _dataFolder, Web _parent, string moduleName = null) : base(moduleName) {
			this.staticPart = _staticPart;
			this.parent = _parent;

			if (File.Exists (_dataFolder + "/sessionheader.tmpl")) {
				header = File.ReadAllText (_dataFolder + "/sessionheader.tmpl");
			}

			if (File.Exists (_dataFolder + "/sessionfooter.tmpl")) {
				footer = File.ReadAllText (_dataFolder + "/sessionfooter.tmpl");
			}
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			string subpath = req.Url.AbsolutePath.Remove (0, staticPart.Length);

			StringBuilder result = new StringBuilder ();
			result.Append (header);

			if (subpath.StartsWith ("verify")) {
				if (user != null) {
					resp.Redirect ("/static/index.html");
					return;
				} else {
					result.Append ("<h1>Login failed, <a href=\"/static/index.html\">click to return to main page</a>.</h1>");
				}
			} else if (subpath.StartsWith ("logout")) {
				if (user != null) {
					parent.connectionHandler.LogOut (user.SessionID);
					Cookie cookie = new Cookie ("sid", "", "/");
					cookie.Expired = true;
					resp.AppendCookie (cookie);
					resp.Redirect ("/static/index.html");
					return;
				} else {
					result.Append ("<h1>Not logged in, <a href=\"/static/index.html\">click to return to main page</a>.</h1>");
				}
			} else if (subpath.StartsWith ("login")) {
				string host = (Web.isSslRedirected (req) ? "https://" : "http://") + req.UserHostName;
				string url = OpenID.GetOpenIdLoginUrl (host, host + "/session/verify");
				resp.Redirect (url);
				return;
			} else {
				result.Append ("<h1>Unknown command, <a href=\"/static/index.html\">click to return to main page</a>.</h1>");
			}

			result.Append (footer);

			resp.ContentType = MimeType.GetMimeType (".html");
			resp.ContentEncoding = Encoding.UTF8;
			byte[] buf = Encoding.UTF8.GetBytes (result.ToString ());
			resp.ContentLength64 = buf.Length;
			resp.OutputStream.Write (buf, 0, buf.Length);
		}

	}

}

