using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class EnableOpenIDDebug : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "enable/disable OpenID debugging";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "openiddebug" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 1) {
					SdtdConsole.Instance.Output ("Current state: " + AllocsFixes.NetConnections.Servers.Web.OpenID.debugOpenId);
					return;
				}

				AllocsFixes.NetConnections.Servers.Web.OpenID.debugOpenId = _params[0].Equals("1");
				SdtdConsole.Instance.Output ("Set OpenID debugging to " + _params [0].Equals ("1"));
			} catch (Exception e) {
				Log.Out ("Error in EnableOpenIDDebug.Run: " + e);
			}
		}
	}
}