using System;

namespace AllocsFixes
{
	public class ChatHookExample {
		private const string ANSWER = "     [ff0000]I[-] [ff7f00]W[-][ffff00]A[-][80ff00]S[-] [00ffff]H[-][0080ff]E[-][0000ff]R[-][8b00ff]E[-]";

		public static bool Hook (ClientInfo _cInfo, EChatType _type, string _message, string _playerName) {
			if (!string.IsNullOrEmpty (_message)) {
				if (_message.EqualsCaseInsensitive ("/alloc")) {
					if (_cInfo != null) {
						Log.Out ("Sent chat hook reply to {0}", _cInfo.playerId);
						_cInfo.SendPackage (new NetPackageChat(EChatType.Whisper, -1, ANSWER, "", false, null));
					} else {
						Log.Error ("ChatHookExample: Argument _cInfo null on message: {0}", _message);
					}
					return false;
				}
			}

			return true;
		}

	}
}
