using System;
using System.Collections.Generic;

namespace AllocsFixes
{
	public class API : IModApi {

		public void GameAwake () {
			StateManager.Awake ();
		}

		public void GameShutdown () {
			StateManager.Shutdown ();
		}
		
		public void SavePlayerData (ClientInfo _cInfo, PlayerDataFile _playerDataFile) {
			PlayerDataStuff.GM_SavePlayerData (_cInfo, _playerDataFile);
		}

		public void PlayerSpawning (ClientInfo _cInfo, int _chunkViewDim, PlayerProfile _playerProfile) {
			AllocsLogFunctions.RequestToSpawnPlayer (_cInfo, _chunkViewDim, _playerProfile);
		}
		
		public void PlayerDisconnected (ClientInfo _cInfo, bool _bShutdown) {
			AllocsLogFunctions.PlayerDisconnected (_cInfo, _bShutdown);
		}

		public bool ChatMessage (ClientInfo _cInfo, EChatType _type, int _senderId, string _msg, string _mainName, bool _localizeMain, List<int> _recipientEntityIds) {
			return ChatHookExample.Hook (_cInfo, _type, _msg, _mainName);
		}

		public void InitMod () {
			ModEvents.GameAwake.RegisterHandler (GameAwake);
			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.SavePlayerData.RegisterHandler (SavePlayerData);
			ModEvents.PlayerSpawning.RegisterHandler (PlayerSpawning);
			ModEvents.PlayerDisconnected.RegisterHandler (PlayerDisconnected);
			ModEvents.ChatMessage.RegisterHandler (ChatMessage);
		}
	}
}

