using System;

namespace MapRendering
{
	public class API : IModApi {
		private void GameAwake () {
			// ReSharper disable once ObjectCreationAsStatement
			new AllocsFixes.NetConnections.Servers.Web.Web ();
			AllocsFixes.NetConnections.Servers.Web.LogBuffer.Instance.GetType ();
		}

		private void GameStartDone () {
			if (AllocsFixes.NetConnections.Servers.Web.Handlers.ItemIconHandler.Instance != null) {
				AllocsFixes.NetConnections.Servers.Web.Handlers.ItemIconHandler.Instance.LoadIcons ();
			}
		}

		private void GameShutdown () {
			AllocsFixes.MapRendering.MapRendering.Shutdown ();
		}

		private void CalcChunkColorsDone (Chunk _chunk) {
			AllocsFixes.MapRendering.MapRendering.RenderSingleChunk (_chunk);
		}

		public void InitMod () {
			ModEvents.GameAwake.RegisterHandler (GameAwake);
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);
			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
		}
	}
}

