namespace AllocsFixes.CustomCommands {
	public class Chat {
		public static void SendMessage (ClientInfo _receiver, ClientInfo _sender, string _message) {
			string senderName;
			if (_sender != null) {
				PrivateMessageConnections.SetLastPMSender (_sender, _receiver);
				senderName = _sender.playerName;
			} else {
				senderName = "Server";
			}

			_receiver.SendPackage (new NetPackageGameMessage (EnumGameMessages.Chat, _message, senderName + " (PM)",
				false, "", false));
			string receiverName = _receiver.playerName;
			SdtdConsole.Instance.Output ("Message to player " +
			                             (receiverName != null ? "\"" + receiverName + "\"" : "unknownName") +
			                             " sent with sender \"" + senderName + "\"");
		}
	}
}