using System.Net;
using System.Text;
using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public abstract class WebAPI {
		public static void WriteJSON (HttpListenerResponse resp, JSONNode root) {
			StringBuilder sb = new StringBuilder ();
			root.ToString (sb);
			byte[] buf = Encoding.UTF8.GetBytes (sb.ToString ());
			resp.ContentLength64 = buf.Length;
			resp.ContentType = "application/json";
			resp.ContentEncoding = Encoding.UTF8;
			resp.OutputStream.Write (buf, 0, buf.Length);
		}

		public static void WriteText (HttpListenerResponse _resp, string _text) {
			byte[] buf = Encoding.UTF8.GetBytes (_text);
			_resp.ContentLength64 = buf.Length;
			_resp.ContentType = "text/plain";
			_resp.ContentEncoding = Encoding.UTF8;
			_resp.OutputStream.Write (buf, 0, buf.Length);
		}

		public abstract void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel);

		public virtual int DefaultPermissionLevel () {
			return 0;
		}
	}
}