using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public abstract class PathHandler {
		private readonly string moduleName;

		protected PathHandler (string _moduleName, int _defaultPermissionLevel = 0) {
			moduleName = _moduleName;
			WebPermissions.Instance.AddKnownModule (_moduleName, _defaultPermissionLevel);
		}

		public string ModuleName {
			get { return moduleName; }
		}

		public abstract void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel);

		public bool IsAuthorizedForHandler (WebConnection user, int permissionLevel) {
			if (moduleName != null) {
				return WebPermissions.Instance.ModuleAllowedWithLevel (moduleName, permissionLevel);
			}

			return true;
		}
	}
}