using System.Collections.Generic;
using System.Net;
using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetLog : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			int firstLine, lastLine;

			if (req.QueryString ["firstLine"] == null || !int.TryParse (req.QueryString ["firstLine"], out firstLine)) {
				firstLine = LogBuffer.Instance.OldestLine;
			}

			JSONObject result = new JSONObject ();

			List<LogBuffer.LogEntry> logEntries = LogBuffer.Instance.GetRange (ref firstLine, 50, out lastLine);

			JSONArray entries = new JSONArray ();
			foreach (LogBuffer.LogEntry logEntry in logEntries) {
				JSONObject entry = new JSONObject ();
				entry.Add ("date", new JSONString (logEntry.date));
				entry.Add ("time", new JSONString (logEntry.time));
				entry.Add ("uptime", new JSONString (logEntry.uptime));
				entry.Add ("msg", new JSONString (logEntry.message));
				entry.Add ("trace", new JSONString (logEntry.trace));
				entry.Add ("type", new JSONString (logEntry.type.ToString ()));
				entries.Add (entry);
			}

			result.Add ("firstLine", new JSONNumber (firstLine));
			result.Add ("lastLine", new JSONNumber (lastLine));
			result.Add ("entries", entries);

			WriteJSON (resp, result);
		}
	}
}