using System.Text;

namespace AllocsFixes.JSON {
	public class JSONBoolean : JSONValue {
		private readonly bool value;

		public JSONBoolean (bool value) {
			this.value = value;
		}

		public bool GetBool () {
			return value;
		}

		public override void ToString (StringBuilder stringBuilder, bool prettyPrint = false, int currentLevel = 0) {
			stringBuilder.Append (value ? "true" : "false");
		}

		public static JSONBoolean Parse (string json, ref int offset) {
			//Log.Out ("ParseBool enter (" + offset + ")");

			if (json.Substring (offset, 4).Equals ("true")) {
				//Log.Out ("JSON:Parsed Bool: true");
				offset += 4;
				return new JSONBoolean (true);
			}

			if (json.Substring (offset, 5).Equals ("false")) {
				//Log.Out ("JSON:Parsed Bool: false");
				offset += 5;
				return new JSONBoolean (false);
			}

			throw new MalformedJSONException ("No valid boolean found");
		}
	}
}