using System.Text;

namespace AllocsFixes.JSON {
	public class JSONString : JSONValue {
		private readonly string value;

		public JSONString (string value) {
			this.value = value;
		}

		public string GetString () {
			return value;
		}

		public override void ToString (StringBuilder stringBuilder, bool prettyPrint = false, int currentLevel = 0) {
			if (value == null || value.Length == 0) {
				stringBuilder.Append ("\"\"");
				return;
			}

			int len = value.Length;

			stringBuilder.EnsureCapacity (stringBuilder.Length + 2 * len);

			stringBuilder.Append ('"');

			foreach (char c in value) {
				switch (c) {
					case '\\':
					case '"':

//					case '/':
						stringBuilder.Append ('\\');
						stringBuilder.Append (c);
						break;
					case '\b':
						stringBuilder.Append ("\\b");
						break;
					case '\t':
						stringBuilder.Append ("\\t");
						break;
					case '\n':
						stringBuilder.Append ("\\n");
						break;
					case '\f':
						stringBuilder.Append ("\\f");
						break;
					case '\r':
						stringBuilder.Append ("\\r");
						break;
					default:
						if (c < ' ') {
							stringBuilder.Append ("\\u");
							stringBuilder.Append (((int) c).ToString ("X4"));
						} else {
							stringBuilder.Append (c);
						}

						break;
				}
			}

			stringBuilder.Append ('"');
		}

		public static JSONString Parse (string json, ref int offset) {
			//Log.Out ("ParseString enter (" + offset + ")");
			StringBuilder sb = new StringBuilder ();
			offset++;
			while (offset < json.Length) {
				switch (json [offset]) {
					case '\\':
						offset++;
						switch (json [offset]) {
							case '\\':
							case '"':
							case '/':
								sb.Append (json [offset]);
								break;
							case 'b':
								sb.Append ('\b');
								break;
							case 't':
								sb.Append ('\t');
								break;
							case 'n':
								sb.Append ('\n');
								break;
							case 'f':
								sb.Append ('\f');
								break;
							case 'r':
								sb.Append ('\r');
								break;
							default:
								sb.Append (json [offset]);
								break;
						}

						offset++;
						break;
					case '"':
						offset++;

						//Log.Out ("JSON:Parsed String: " + sb.ToString ());
						return new JSONString (sb.ToString ());
					default:
						sb.Append (json [offset]);
						offset++;
						break;
				}
			}

			throw new MalformedJSONException ("End of JSON reached before parsing string finished");
		}
	}
}