using System.Collections.Generic;
using System.Net;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetPlayerInventory : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			if (req.QueryString ["steamid"] == null) {
				resp.StatusCode = (int) HttpStatusCode.InternalServerError;
				Web.SetResponseTextContent (resp, "No SteamID given");
				return;
			}

			Player p = PersistentContainer.Instance.Players [req.QueryString ["steamid"], false];
			if (p == null) {
				resp.StatusCode = (int) HttpStatusCode.InternalServerError;
				Web.SetResponseTextContent (resp, "Invalid or unknown SteamID given");
				return;
			}

			PersistentData.Inventory inv = p.Inventory;


			JSONObject result = new JSONObject ();

			JSONArray bag = new JSONArray ();
			JSONArray belt = new JSONArray ();
			JSONObject equipment = new JSONObject ();
			result.Add ("playername", new JSONString (p.Name));
			result.Add ("bag", bag);
			result.Add ("belt", belt);
			result.Add ("equipment", equipment);

			DoInventory (belt, inv.belt);
			DoInventory (bag, inv.bag);

			AddEquipment (equipment, "head", inv.equipment, EquipmentSlots.Headgear);
			AddEquipment (equipment, "eyes", inv.equipment, EquipmentSlots.Eyewear);
			AddEquipment (equipment, "face", inv.equipment, EquipmentSlots.Face);

			AddEquipment (equipment, "armor", inv.equipment, EquipmentSlots.ChestArmor);
			AddEquipment (equipment, "jacket", inv.equipment, EquipmentSlots.Jacket);
			AddEquipment (equipment, "shirt", inv.equipment, EquipmentSlots.Shirt);

			AddEquipment (equipment, "legarmor", inv.equipment, EquipmentSlots.LegArmor);
			AddEquipment (equipment, "pants", inv.equipment, EquipmentSlots.Legs);
			AddEquipment (equipment, "boots", inv.equipment, EquipmentSlots.Feet);

			AddEquipment (equipment, "gloves", inv.equipment, EquipmentSlots.Hands);

			WriteJSON (resp, result);
		}

		internal static void DoInventory (JSONArray _jsonRes, List<InvItem> _inv) {
			for (int i = 0; i < _inv.Count; i++) {
				_jsonRes.Add (GetJsonForItem (_inv [i]));
			}
		}

		internal static void AddEquipment (JSONObject _eq, string _slotname, InvItem[] _items, EquipmentSlots _slot) {
			int[] slotindices = XUiM_PlayerEquipment.GetSlotIndicesByEquipmentSlot (_slot);

			for (int i = 0; i < slotindices.Length; i++) {
				if (_items != null && _items [slotindices [i]] != null) {
					InvItem item = _items [slotindices [i]];
					_eq.Add (_slotname, GetJsonForItem (item));
					return;
				}
			}

			_eq.Add (_slotname, new JSONNull ());
		}

		internal static JSONNode GetJsonForItem (InvItem _item) {
			if (_item == null) {
				return new JSONNull ();
			}

			JSONObject jsonItem = new JSONObject ();
			jsonItem.Add ("count", new JSONNumber (_item.count));
			jsonItem.Add ("name", new JSONString (_item.itemName));
			jsonItem.Add ("icon", new JSONString (_item.icon));
			jsonItem.Add ("iconcolor", new JSONString (_item.iconcolor));
			jsonItem.Add ("quality", new JSONNumber (_item.quality));
			if (_item.quality >= 0) {
				jsonItem.Add ("qualitycolor", new JSONString (QualityInfo.GetQualityColorHex (_item.quality)));
			}

			return jsonItem;

		}
	}
}