using AllocsFixes.NetConnections.Servers.Web;
using AllocsFixes.NetConnections.Servers.Web.Handlers;

namespace AllocsFixes {
	public class API : IModApi {
		public void InitMod () {
			ModEvents.GameAwake.RegisterHandler (GameAwake);
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);
			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
		}

		private void GameAwake () {
			// ReSharper disable once ObjectCreationAsStatement
			new Web ();
			LogBuffer.Init ();
		}

		private void GameStartDone () {
			if (ItemIconHandler.Instance != null) {
				ItemIconHandler.Instance.LoadIcons ();
			}
		}

		private void GameShutdown () {
			AllocsFixes.MapRendering.MapRendering.Shutdown ();
		}

		private void CalcChunkColorsDone (Chunk _chunk) {
			AllocsFixes.MapRendering.MapRendering.RenderSingleChunk (_chunk);
		}
	}
}