using System.IO;
using System.Net;
using AllocsFixes.FileCache;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public class StaticHandler : PathHandler {
		private readonly AbstractCache cache;
		private readonly string datapath;
		private readonly bool logMissingFiles;
		private readonly string staticPart;

		public StaticHandler (string staticPart, string filePath, AbstractCache cache, bool logMissingFiles,
			string moduleName = null) : base (moduleName) {
			this.staticPart = staticPart;
			datapath = filePath + (filePath [filePath.Length - 1] == '/' ? "" : "/");
			this.cache = cache;
			this.logMissingFiles = logMissingFiles;
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			string fn = req.Url.AbsolutePath.Remove (0, staticPart.Length);

			byte[] content = cache.GetFileContent (datapath + fn);

			if (content != null) {
				resp.ContentType = MimeType.GetMimeType (Path.GetExtension (fn));
				resp.ContentLength64 = content.Length;
				resp.OutputStream.Write (content, 0, content.Length);
			} else {
				resp.StatusCode = (int) HttpStatusCode.NotFound;
				if (logMissingFiles) {
					Log.Out ("Web:Static:FileNotFound: \"" + req.Url.AbsolutePath + "\" @ \"" + datapath + fn + "\"");
				}
			}
		}
	}
}