using System.Net;
using AllocsFixes.JSON;
using AllocsFixes.NetConnections.Servers.Web.API;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public class UserStatusHandler : PathHandler {
		public UserStatusHandler (string moduleName = null) : base (moduleName) {
		}

		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			JSONObject result = new JSONObject ();

			result.Add ("loggedin", new JSONBoolean (user != null));
			result.Add ("username", new JSONString (user != null ? user.SteamID.ToString () : string.Empty));

			JSONArray perms = new JSONArray ();
			foreach (WebPermissions.WebModulePermission perm in WebPermissions.Instance.GetModules ()) {
				JSONObject permObj = new JSONObject ();
				permObj.Add ("module", new JSONString (perm.module));
				permObj.Add ("allowed", new JSONBoolean (perm.permissionLevel >= permissionLevel));
				perms.Add (permObj);
			}

			result.Add ("permissions", perms);

			WebAPI.WriteJSON (resp, result);
		}
	}
}