using System.Collections.Generic;
using System.Net;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetPlayerInventories : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			JSONArray AllInventoriesResult = new JSONArray ();

			foreach (KeyValuePair<string, Player> kvp in PersistentContainer.Instance.Players.Dict) {
				Player p = kvp.Value;

				if (p == null) {
					continue;
				}

				if (p.IsOnline) {
					PersistentData.Inventory inv = p.Inventory;

					JSONObject result = new JSONObject ();
					JSONArray bag = new JSONArray ();
					JSONArray belt = new JSONArray ();
					JSONObject equipment = new JSONObject ();
					result.Add ("steamid", new JSONString (kvp.Key));
					result.Add ("entityid", new JSONNumber (p.EntityID));
					result.Add ("playername", new JSONString (p.Name));
					result.Add ("bag", bag);
					result.Add ("belt", belt);
					result.Add ("equipment", equipment);

					GetPlayerInventory.DoInventory (belt, inv.belt);
					GetPlayerInventory.DoInventory (bag, inv.bag);

					GetPlayerInventory.AddEquipment (equipment, "head", inv.equipment, EquipmentSlots.Headgear);
					GetPlayerInventory.AddEquipment (equipment, "eyes", inv.equipment, EquipmentSlots.Eyewear);
					GetPlayerInventory.AddEquipment (equipment, "face", inv.equipment, EquipmentSlots.Face);

					GetPlayerInventory.AddEquipment (equipment, "armor", inv.equipment, EquipmentSlots.ChestArmor);
					GetPlayerInventory.AddEquipment (equipment, "jacket", inv.equipment, EquipmentSlots.Jacket);
					GetPlayerInventory.AddEquipment (equipment, "shirt", inv.equipment, EquipmentSlots.Shirt);

					GetPlayerInventory.AddEquipment (equipment, "legarmor", inv.equipment, EquipmentSlots.LegArmor);
					GetPlayerInventory.AddEquipment (equipment, "pants", inv.equipment, EquipmentSlots.Legs);
					GetPlayerInventory.AddEquipment (equipment, "boots", inv.equipment, EquipmentSlots.Feet);

					GetPlayerInventory.AddEquipment (equipment, "gloves", inv.equipment, EquipmentSlots.Hands);

					AllInventoriesResult.Add (result);
				}
			}

			WriteJSON (resp, AllInventoriesResult);
		}
	}
}