using System;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class ExecuteConsoleCommand : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user,
			int permissionLevel) {
			if (string.IsNullOrEmpty (req.QueryString ["command"])) {
				resp.StatusCode = (int) HttpStatusCode.BadRequest;
				Web.SetResponseTextContent (resp, "No command given");
				return;
			}

			WebCommandResult.ResultType responseType =
				req.QueryString ["raw"] != null
					? WebCommandResult.ResultType.Raw
					: (req.QueryString ["simple"] != null
						? WebCommandResult.ResultType.ResultOnly
						: WebCommandResult.ResultType.Full);

			string commandline = req.QueryString ["command"];
			string commandPart = commandline.Split (' ') [0];
			string argumentsPart = commandline.Substring (Math.Min (commandline.Length, commandPart.Length + 1));

			IConsoleCommand command = SdtdConsole.Instance.GetCommand (commandline);

			if (command == null) {
				resp.StatusCode = (int) HttpStatusCode.NotFound;
				Web.SetResponseTextContent (resp, "Unknown command");
				return;
			}

			AdminToolsCommandPermissions atcp =
				GameManager.Instance.adminTools.GetAdminToolsCommandPermission (command.GetCommands ());

			if (permissionLevel > atcp.PermissionLevel) {
				resp.StatusCode = (int) HttpStatusCode.Forbidden;
				Web.SetResponseTextContent (resp, "You are not allowed to execute this command");
				return;
			}

			resp.SendChunked = true;
			WebCommandResult wcr = new WebCommandResult (commandPart, argumentsPart, responseType, resp);
			SdtdConsole.Instance.ExecuteAsync (commandline, wcr);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}