#!/bin/bash

# Tries to start the 7dtd instance.

sdtdCommandUpdateengine() {
	for I in $(getInstanceList); do
		if [ $(isRunning $I) -eq 1 ]; then
			echo "At least one instance is still running (\"$I\")."
			echo "Before updating the engine please stop all instances!"
			return
		fi
	done

	if [ ! -e $SDTD_BASE/steamcmd ]; then
		mkdir $SDTD_BASE/steamcmd
		cd /tmp
		wget http://media.steampowered.com/installer/steamcmd_linux.tar.gz
		tar -xvzf steamcmd_linux.tar.gz -C $SDTD_BASE/steamcmd
		cd $SDTD_BASE/steamcmd
		./steamcmd.sh +quit
	fi

	cd $SDTD_BASE/steamcmd

	./steamcmd.sh +@sSteamCmdForcePlatformType windows +login $STEAM_USER $STEAM_PASS +force_install_dir $SDTD_BASE/engine "+app_update 251570" validate +quit

	cp $SDTD_BASE/linux_files/engine/* $SDTD_BASE/engine/ -R
	cp $SDTD_BASE/engine/Install/32bit/SteamworksManaged.dll $SDTD_BASE/engine/7DaysToDie_Data/Managed/

	chown $SDTD_USER.$SDTD_GROUP -R $SDTD_BASE/engine
}

sdtdCommandUpdateengineHelp() {
	echo "Usage: $(basename $0) updateengine"
	echo
	echo "Update the engine (aka game) files of 7dtd."
}

sdtdCommandUpdateengineDescription() {
	echo "Update the 7dtd engine files"
}
