using System;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using AllocsFixes.JSON;
using UnityEngine;

namespace AllocsFixes.NetConnections.Servers.Web.SSE {
	public class EventLog : EventBase {
		private static readonly Regex logMessageMatcher =
			new Regex (@"^([0-9]{4}-[0-9]{2}-[0-9]{2})T([0-9]{2}:[0-9]{2}:[0-9]{2}) ([0-9]+[,.][0-9]+) [A-Z]+ (.*)$");

		public EventLog (SseHandler _parent) : base (_parent, _name: "log") {
			Logger.Main.LogCallbacks += LogCallback;
		}


		private void LogCallback (string _msg, string _trace, LogType _type) {
			Match match = logMessageMatcher.Match (_msg);

			string date;
			string time;
			string uptime;
			string message;
			if (match.Success) {
				date = match.Groups [1].Value;
				time = match.Groups [2].Value;
				uptime = match.Groups [3].Value;
				message = match.Groups [4].Value;
			} else {
				DateTime dt = DateTime.Now;
				date = $"{dt.Year:0000}-{dt.Month:00}-{dt.Day:00}";
				time = $"{dt.Hour:00}:{dt.Minute:00}:{dt.Second:00}";
				uptime = "";
				message = _msg;
			}

			JSONObject data = new JSONObject ();
			data.Add ("msg", new JSONString (message));
			data.Add ("type", new JSONString (_type.ToStringCached ()));
			data.Add ("trace", new JSONString (_trace));
			data.Add ("date", new JSONString (date));
			data.Add ("time", new JSONString (time));
			data.Add ("uptime", new JSONString (uptime));

			SendData ("logLine", data);
		}
		
	}
}