using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands {
	public class ConsoleCmdException : ConsoleCmdAbstract {
		public override string[] GetCommands () {
			return new[] { "exception" };
		}

		public override bool AllowedInMainMenu => true;

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			Log.Out ("Test info");
			Log.Warning ("Test warning");
			Log.Error ("Test error");
			throw new Exception ("Test exception");
		}

		public override string GetDescription () {
			return "Throw an exception / log messages";
		}
	}
}