using HttpListenerRequest = SpaceWizards.HttpListener.HttpListenerRequest;
using HttpListenerResponse = SpaceWizards.HttpListener.HttpListenerResponse;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public class RewriteHandler : AbsHandler {
		private readonly string target;
		private readonly bool fixedTarget;

		public RewriteHandler (string _target, bool _fixedTarget = false) : base (null) {
			target = _target;
			fixedTarget = _fixedTarget;
		}

		public override void HandleRequest (string _requestPath, HttpListenerRequest _req, HttpListenerResponse _resp, WebConnection _con,
			int _permissionLevel) {
			string newRequestPath = fixedTarget ? target : target + _requestPath.Remove (0, urlBasePath.Length);
			parent.ApplyPathHandler (newRequestPath, _req, _resp, _con, _permissionLevel);
		}
	}
}