using HttpListenerRequest = SpaceWizards.HttpListener.HttpListenerRequest;
using HttpListenerResponse = SpaceWizards.HttpListener.HttpListenerResponse;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public abstract class AbsHandler {
		protected readonly string moduleName;
		protected string urlBasePath;
		protected Web parent;

		public string ModuleName => moduleName;
		public string UrlBasePath => urlBasePath;

		protected AbsHandler (string _moduleName, int _defaultPermissionLevel = 0) {
			moduleName = _moduleName;
			WebPermissions.Instance.AddKnownModule (_moduleName, _defaultPermissionLevel);
		}

		public abstract void HandleRequest (string _requestPath, HttpListenerRequest _req, HttpListenerResponse _resp, WebConnection _con,
			int _permissionLevel);

		public virtual bool IsAuthorizedForHandler (WebConnection _user, int _permissionLevel) {
			return moduleName == null || WebPermissions.Instance.ModuleAllowedWithLevel (moduleName, _permissionLevel);
		}

		public virtual void Shutdown () {
		}

		public virtual void SetBasePathAndParent (Web _parent, string _relativePath) {
			parent = _parent;
			urlBasePath = _relativePath;
		}
	}
}