using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetWebMods : AbsWebAPI {
		private readonly JSONArray loadedWebMods = new JSONArray ();

		public GetWebMods (Web _parent) {
			foreach (WebMod webMod in _parent.webMods) {
				JSONObject modJson = new JSONObject ();

				modJson.Add ("name", new JSONString (webMod.ParentMod.ModInfo.Name.Value));
				
				string webModReactBundle = webMod.ReactBundle;
				if (webModReactBundle != null) {
					modJson.Add ("bundle", new JSONString (webModReactBundle));
				}

				string webModCssFile = webMod.CssPath;
				if (webModCssFile != null) {
					modJson.Add ("css", new JSONString (webModCssFile));
				}

				loadedWebMods.Add (modJson);
			}
		}

		public override void HandleRequest (RequestContext _context) {
			WebUtils.WriteJson (_context.Response, loadedWebMods);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}