using System.Collections.Generic;
using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetLog : AbsWebAPI {
		private const int MAX_COUNT = 1000;
		
		public override void HandleRequest (RequestContext _context) {
			if (_context.Request.QueryString ["count"] == null || !int.TryParse (_context.Request.QueryString ["count"], out int count)) {
				count = 50;
			}

			if (count == 0) {
				count = 1;
			}

			if (count > MAX_COUNT) {
				count = MAX_COUNT;
			}

			if (count < -MAX_COUNT) {
				count = -MAX_COUNT;
			}

			if (_context.Request.QueryString ["firstLine"] == null || !int.TryParse (_context.Request.QueryString ["firstLine"], out int firstLine)) {
				firstLine = count > 0 ? LogBuffer.Instance.OldestLine : LogBuffer.Instance.LatestLine;
			}

			JSONObject result = new JSONObject ();

			List<LogBuffer.LogEntry> logEntries = LogBuffer.Instance.GetRange (ref firstLine, count, out int lastLine);

			JSONArray entries = new JSONArray ();
			foreach (LogBuffer.LogEntry logEntry in logEntries) {
				JSONObject entry = new JSONObject ();
				entry.Add ("isotime", new JSONString (logEntry.isoTime));
				entry.Add ("uptime", new JSONString (logEntry.uptime.ToString ()));
				entry.Add ("msg", new JSONString (logEntry.message));
				entry.Add ("trace", new JSONString (logEntry.trace));
				entry.Add ("type", new JSONString (logEntry.type.ToStringCached ()));
				entries.Add (entry);
			}

			result.Add ("firstLine", new JSONNumber (firstLine));
			result.Add ("lastLine", new JSONNumber (lastLine));
			result.Add ("entries", entries);

			WebUtils.WriteJson (_context.Response, result);
		}
	}
}