using System;
using AllocsFixes.JSON;
using UnityEngine;

namespace AllocsFixes.NetConnections.Servers.Web.SSE {
	public class EventLog : EventBase {
		public EventLog (SseHandler _parent) : base (_parent, _name: "log") {
			Log.LogCallbacksExtended += LogCallback;
		}

		private void LogCallback (string _formattedMsg, string _plainMsg, string _trace, LogType _type, DateTime _timestamp, long _uptime) {
			string isotime = _timestamp.ToString ("o");
			string uptime = _uptime.ToString ();
			string message = _plainMsg;

			JSONObject data = new JSONObject ();
			data.Add ("msg", new JSONString (message));
			data.Add ("type", new JSONString (_type.ToStringCached ()));
			data.Add ("trace", new JSONString (_trace));
			data.Add ("isotime", new JSONString (isotime));
			data.Add ("uptime", new JSONString (uptime));

			SendData ("logLine", data);
		}
	}
}