using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	public class GetPlayerInventories : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			GetPlayerInventory.GetInventoryArguments (_context.Request, out bool showIconColor, out bool showIconName);

			JSONArray AllInventoriesResult = new JSONArray ();

			foreach (KeyValuePair<PlatformUserIdentifierAbs, Player> kvp in PersistentContainer.Instance.Players.Dict) {
				Player p = kvp.Value;

				if (p == null) {
					continue;
				}

				if (p.IsOnline) {
					AllInventoriesResult.Add (GetPlayerInventory.DoPlayer (kvp.Key.CombinedString, p, showIconColor, showIconName));
				}
			}

			WebUtils.WriteJson (_context.Response, AllInventoriesResult);
		}
	}
}