using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers {
	public class UserStatusHandler : AbsHandler {
		public UserStatusHandler (string _moduleName = null) : base (_moduleName) {
		}

		public override void HandleRequest (RequestContext _context) {
			JSONObject result = new JSONObject ();

			result.Add ("loggedin", new JSONBoolean (_context.Connection != null));
			result.Add ("username", new JSONString (_context.Connection != null ? _context.Connection.UserId.ToString () : string.Empty));

			JSONArray perms = new JSONArray ();
			foreach (WebPermissions.WebModulePermission perm in WebPermissions.Instance.GetModules ()) {
				JSONObject permObj = new JSONObject ();
				permObj.Add ("module", new JSONString (perm.module));
				permObj.Add ("allowed", new JSONBoolean (perm.permissionLevel >= _context.PermissionLevel));
				perms.Add (permObj);
			}

			result.Add ("permissions", perms);

			WebUtils.WriteJson (_context.Response, result);
		}
	}
}