using System;
using System.Collections.Generic;
using System.Net;
using AllocsFixes.JSON;

namespace AllocsFixes.NetConnections.Servers.Web.API {
	class Markers : AbsRestApi {
		private readonly Dictionary<string, (string, string)> markers = new Dictionary<string, (string, string)> ();

		private static readonly JSONArray emptyResult = new JSONArray ();
		
		public Markers () {
			markers.Add (WebUtils.GenerateGuid (), ("539", "498"));
			markers.Add (WebUtils.GenerateGuid (), ("-18", "524"));
			markers.Add (WebUtils.GenerateGuid (), ("29", "-162"));
			markers.Add (WebUtils.GenerateGuid (), ("458", "-257"));
		}

		protected override void HandleRestGet (RequestContext _context) {
			string id = _context.RequestPath;
			
			if (string.IsNullOrEmpty (id)) {
				JSONArray result = new JSONArray ();

				foreach (KeyValuePair<string, (string, string)> kvp in markers) {
					JSONObject marker = new JSONObject ();
					marker.Add ("id", new JSONString (kvp.Key));
					marker.Add ("lat", new JSONString (kvp.Value.Item1));
					marker.Add ("lng", new JSONString (kvp.Value.Item2));
					result.Add (marker);
				}
				
				SendEnvelopedResult (_context, result);
				return;
			}

			if (!markers.TryGetValue (id, out (string, string) location)) {
				SendEnvelopedResult (_context, emptyResult, HttpStatusCode.NotFound);
				return;
			}

			{
				JSONArray result = new JSONArray ();
				JSONObject marker = new JSONObject ();
				marker.Add ("id", new JSONString (id));
				marker.Add ("lat", new JSONString (location.Item1));
				marker.Add ("lng", new JSONString (location.Item2));
				result.Add (marker);
				SendEnvelopedResult (_context, result);
			}
		}

		protected override void HandleRestPost (RequestContext _context, JSONNode _jsonBody) {
			if (!(_jsonBody is JSONObject bodyObject)) {
				
			}

			throw new NotImplementedException ();
		}

		protected override void HandleRestPut (RequestContext _context, JSONNode _jsonBody) {
			throw new NotImplementedException ();
		}

		protected override void HandleRestDelete (RequestContext _context) {
			throw new NotImplementedException ();
		}
	}
}