using System.Collections.Generic;
using System.Text;

namespace AllocsFixes.JSON {
	public class JsonArray : JsonNode {
		private readonly List<JsonNode> nodes = new List<JsonNode> ();

		public JsonNode this [int _index] {
			get => nodes [_index];
			set => nodes [_index] = value;
		}

		public int Count => nodes.Count;

		public void Add (JsonNode _node) {
			nodes.Add (_node);
		}

		public override void ToString (StringBuilder _stringBuilder, bool _prettyPrint = false, int _currentLevel = 0) {
			_stringBuilder.Append ("[");
			if (_prettyPrint) {
				_stringBuilder.Append ('\n');
			}

			foreach (JsonNode n in nodes) {
				if (_prettyPrint) {
					_stringBuilder.Append (new string ('\t', _currentLevel + 1));
				}

				n.ToString (_stringBuilder, _prettyPrint, _currentLevel + 1);
				_stringBuilder.Append (",");
				if (_prettyPrint) {
					_stringBuilder.Append ('\n');
				}
			}

			if (nodes.Count > 0) {
				_stringBuilder.Remove (_stringBuilder.Length - (_prettyPrint ? 2 : 1), 1);
			}

			if (_prettyPrint) {
				_stringBuilder.Append (new string ('\t', _currentLevel));
			}

			_stringBuilder.Append ("]");
		}

		public static JsonArray Parse (string _json, ref int _offset) {
			//Log.Out ("ParseArray enter (" + offset + ")");
			JsonArray arr = new JsonArray ();

			bool nextElemAllowed = true;
			_offset++;
			while (true) {
				Parser.SkipWhitespace (_json, ref _offset);

				switch (_json [_offset]) {
					case ',':
						if (!nextElemAllowed) {
							nextElemAllowed = true;
							_offset++;
						} else {
							throw new MalformedJsonException (
								"Could not parse array, found a comma without a value first");
						}

						break;
					case ']':
						_offset++;

						//Log.Out ("JSON:Parsed Array: " + arr.ToString ());
						return arr;
					default:
						arr.Add (Parser.ParseInternal (_json, ref _offset));
						nextElemAllowed = false;
						break;
				}
			}
		}
	}
}