using System;
using System.Text;

namespace AllocsFixes.JSON {
	public class JsonNull : JsonValue {
		public override void ToString (StringBuilder _stringBuilder, bool _prettyPrint = false, int _currentLevel = 0) {
			_stringBuilder.Append ("null");
		}

		public static JsonNull Parse (string _json, ref int _offset) {
			//Log.Out ("ParseNull enter (" + offset + ")");

			if (!_json.Substring (_offset, 4).Equals ("null")) {
				throw new MalformedJsonException ("No valid null value found");
			}

			//Log.Out ("JSON:Parsed Null");
			_offset += 4;
			return new JsonNull ();
		}

		public override string AsString => throw new NotSupportedException ();
		public override int AsInt => throw new NotSupportedException ();
		public override double AsDouble => throw new NotSupportedException ();
	}
}