namespace AllocsFixes.JSON {
	public static class Parser {
		public static JsonNode Parse (string _json) {
			int offset = 0;
			return ParseInternal (_json, ref offset);
		}

		public static JsonNode ParseInternal (string _json, ref int _offset) {
			SkipWhitespace (_json, ref _offset);

			//Log.Out ("ParseInternal (" + offset + "): Decide on: '" + json [offset] + "'");
			switch (_json [_offset]) {
				case '[':
					return JsonArray.Parse (_json, ref _offset);
				case '{':
					return JsonObject.Parse (_json, ref _offset);
				case '"':
					return JsonString.Parse (_json, ref _offset);
				case 't':
				case 'f':
					return JsonBoolean.Parse (_json, ref _offset);
				case 'n':
					return JsonNull.Parse (_json, ref _offset);
				default:
					return JsonNumber.Parse (_json, ref _offset);
			}
		}

		public static void SkipWhitespace (string _json, ref int _offset) {
			//Log.Out ("SkipWhitespace (" + offset + "): '" + json [offset] + "'");
			while (_offset < _json.Length) {
				switch (_json [_offset]) {
					case ' ':
					case '\t':
					case '\r':
					case '\n':
						_offset++;
						break;
					default:
						return;
				}
			}

			throw new MalformedJsonException ("End of JSON reached before parsing finished");
		}
	}
}