using System.Text;

namespace AllocsFixes.JSON {
	public class JsonBoolean : JsonValue {
		private readonly bool value;

		public JsonBoolean (bool _value) {
			value = _value;
		}

		public bool GetBool () {
			return value;
		}

		public override void ToString (StringBuilder _stringBuilder, bool _prettyPrint = false, int _currentLevel = 0) {
			_stringBuilder.Append (value ? "true" : "false");
		}

		public static JsonBoolean Parse (string _json, ref int _offset) {
			//Log.Out ("ParseBool enter (" + offset + ")");

			if (_json.Substring (_offset, 4).Equals ("true")) {
				//Log.Out ("JSON:Parsed Bool: true");
				_offset += 4;
				return new JsonBoolean (true);
			}

			if (_json.Substring (_offset, 5).Equals ("false")) {
				//Log.Out ("JSON:Parsed Bool: false");
				_offset += 5;
				return new JsonBoolean (false);
			}

			throw new MalformedJsonException ("No valid boolean found");
		}

		public override string AsString => value ? "true" : "false";
		public override int AsInt => value ? 1 : 0;
		public override double AsDouble => AsInt;
	}
}