using JetBrains.Annotations;

namespace MapRendering {
	[UsedImplicitly]
	public class ModApi : IModApi {
		public void InitMod (Mod _modInstance) {
			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
		}

		private void GameShutdown () {
			MapRenderer.Shutdown ();
		}

		private void CalcChunkColorsDone (Chunk _chunk) {
			MapRenderer.RenderSingleChunk (_chunk);
		}
	}
}