using System;
using AllocsFixes.JSON;
using JetBrains.Annotations;
using UnityEngine;
using Webserver.UrlHandlers;

namespace Webserver.SSE {
	[UsedImplicitly]
	public class EventLog : AbsEvent {
		public EventLog (SseHandler _parent) : base (_parent, _name: "log") {
			Log.LogCallbacksExtended += LogCallback;
		}

		private void LogCallback (string _formattedMsg, string _plainMsg, string _trace, LogType _type, DateTime _timestamp, long _uptime) {
			string isotime = _timestamp.ToString ("o");
			string uptime = _uptime.ToString ();

			JsonObject data = new JsonObject ();
			data.Add ("msg", new JsonString (_plainMsg));
			data.Add ("type", new JsonString (_type.ToStringCached ()));
			data.Add ("trace", new JsonString (_trace));
			data.Add ("isotime", new JsonString (isotime));
			data.Add ("uptime", new JsonString (uptime));

			SendData ("logLine", data);
		}
	}
}