using AllocsFixes.JSON;

namespace Webserver.UrlHandlers {
	public class UserStatusHandler : AbsHandler {
		public UserStatusHandler (string _moduleName = null) : base (_moduleName) {
		}

		public override void HandleRequest (RequestContext _context) {
			JsonObject result = new JsonObject ();

			result.Add ("loggedin", new JsonBoolean (_context.Connection != null));
			result.Add ("username", new JsonString (_context.Connection != null ? _context.Connection.UserId.ToString () : string.Empty));

			JsonArray perms = new JsonArray ();
			foreach (WebPermissions.WebModulePermission perm in WebPermissions.Instance.GetModules ()) {
				JsonObject permObj = new JsonObject ();
				permObj.Add ("module", new JsonString (perm.module));
				permObj.Add ("allowed", new JsonBoolean (perm.permissionLevel >= _context.PermissionLevel));
				perms.Add (permObj);
			}

			result.Add ("permissions", perms);

			WebUtils.WriteJson (_context.Response, result);
		}
	}
}