﻿using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	internal class GetHostileLocation : AbsWebAPI {
		private readonly List<EntityEnemy> enemies = new List<EntityEnemy> ();

		public override void HandleRequest (RequestContext _context) {
			JsonArray hostilesJsResult = new JsonArray ();

			Hostiles.Instance.Get (enemies);
			for (int i = 0; i < enemies.Count; i++) {
				EntityEnemy entity = enemies [i];
				Vector3i position = new Vector3i (entity.GetPosition ());

				JsonObject jsonPOS = new JsonObject ();
				jsonPOS.Add ("x", new JsonNumber (position.x));
				jsonPOS.Add ("y", new JsonNumber (position.y));
				jsonPOS.Add ("z", new JsonNumber (position.z));

				JsonObject pJson = new JsonObject ();
				pJson.Add ("id", new JsonNumber (entity.entityId));

				if (!string.IsNullOrEmpty (entity.EntityName)) {
					pJson.Add ("name", new JsonString (entity.EntityName));
				} else {
					pJson.Add ("name", new JsonString ("enemy class #" + entity.entityClass));
				}

				pJson.Add ("position", jsonPOS);

				hostilesJsResult.Add (pJson);
			}

			WebUtils.WriteJson (_context.Response, hostilesJsResult);
		}
	}
}