using System.Collections.Generic;
using AllocsFixes.JSON;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetLog : AbsWebAPI {
		private const int MAX_COUNT = 1000;
		
		public override void HandleRequest (RequestContext _context) {
			if (_context.Request.QueryString ["count"] == null || !int.TryParse (_context.Request.QueryString ["count"], out int count)) {
				count = 50;
			}

			if (count == 0) {
				count = 1;
			}

			if (count > MAX_COUNT) {
				count = MAX_COUNT;
			}

			if (count < -MAX_COUNT) {
				count = -MAX_COUNT;
			}

			if (_context.Request.QueryString ["firstLine"] == null || !int.TryParse (_context.Request.QueryString ["firstLine"], out int firstLine)) {
				firstLine = count > 0 ? LogBuffer.Instance.OldestLine : LogBuffer.Instance.LatestLine;
			}

			JsonObject result = new JsonObject ();

			List<LogBuffer.LogEntry> logEntries = LogBuffer.Instance.GetRange (ref firstLine, count, out int lastLine);

			JsonArray entries = new JsonArray ();
			foreach (LogBuffer.LogEntry logEntry in logEntries) {
				JsonObject entry = new JsonObject ();
				entry.Add ("isotime", new JsonString (logEntry.isoTime));
				entry.Add ("uptime", new JsonString (logEntry.uptime.ToString ()));
				entry.Add ("msg", new JsonString (logEntry.message));
				entry.Add ("trace", new JsonString (logEntry.trace));
				entry.Add ("type", new JsonString (logEntry.type.ToStringCached ()));
				entries.Add (entry);
			}

			result.Add ("firstLine", new JsonNumber (firstLine));
			result.Add ("lastLine", new JsonNumber (lastLine));
			result.Add ("entries", entries);

			WebUtils.WriteJson (_context.Response, result);
		}
	}
}