using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetStats : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			JsonObject result = new JsonObject ();

			JsonObject time = new JsonObject ();
			time.Add ("days", new JsonNumber (GameUtils.WorldTimeToDays (GameManager.Instance.World.worldTime)));
			time.Add ("hours", new JsonNumber (GameUtils.WorldTimeToHours (GameManager.Instance.World.worldTime)));
			time.Add ("minutes", new JsonNumber (GameUtils.WorldTimeToMinutes (GameManager.Instance.World.worldTime)));
			result.Add ("gametime", time);

			result.Add ("players", new JsonNumber (GameManager.Instance.World.Players.Count));
			result.Add ("hostiles", new JsonNumber (Hostiles.Instance.GetCount ()));
			result.Add ("animals", new JsonNumber (Animals.Instance.GetCount ()));

			WebUtils.WriteJson (_context.Response, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}