using System.Collections.Generic;
using System.Net;
using AllocsFixes;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetLandClaims : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			PlatformUserIdentifierAbs requestedUserId = null;
			if (_context.Request.QueryString ["userid"] != null) {
				if (!PlatformUserIdentifierAbs.TryFromCombinedString (_context.Request.QueryString ["userid"], out requestedUserId)) {
					WebUtils.WriteText (_context.Response, "Invalid user id given", HttpStatusCode.BadRequest);
					return;
				}
			}

			// default user, cheap way to avoid 'null reference exception'
			PlatformUserIdentifierAbs userId = _context.Connection?.UserId;

			bool bViewAll = WebConnection.CanViewAllClaims (_context.PermissionLevel);

			JsonObject result = new JsonObject ();
			result.Add ("claimsize", new JsonNumber (GamePrefs.GetInt (EnumUtils.Parse<EnumGamePrefs> ("LandClaimSize"))));

			JsonArray claimOwners = new JsonArray ();
			result.Add ("claimowners", claimOwners);

			LandClaimList.OwnerFilter[] ownerFilters = null;
			if (requestedUserId != null || !bViewAll) {
				if (requestedUserId != null && !bViewAll) {
					ownerFilters = new[] {
						LandClaimList.UserIdFilter (userId),
						LandClaimList.UserIdFilter (requestedUserId)
					};
				} else if (!bViewAll) {
					ownerFilters = new[] {LandClaimList.UserIdFilter (userId)};
				} else {
					ownerFilters = new[] {LandClaimList.UserIdFilter (requestedUserId)};
				}
			}

			LandClaimList.PositionFilter[] posFilters = null;

			Dictionary<Player, List<Vector3i>> claims = LandClaimList.GetLandClaims (ownerFilters, posFilters);

			foreach ((Player player, List<Vector3i> claimPositions) in claims) {
				JsonObject owner = new JsonObject ();
				claimOwners.Add (owner);

				owner.Add ("steamid", new JsonString (player.PlatformId.CombinedString));
				owner.Add ("claimactive", new JsonBoolean (player.LandProtectionActive));

				if (player.Name.Length > 0) {
					owner.Add ("playername", new JsonString (player.Name));
				} else {
					owner.Add ("playername", new JsonNull ());
				}

				JsonArray claimsJson = new JsonArray ();
				owner.Add ("claims", claimsJson);

				foreach (Vector3i v in claimPositions) {
					JsonObject claim = new JsonObject ();
					claim.Add ("x", new JsonNumber (v.x));
					claim.Add ("y", new JsonNumber (v.y));
					claim.Add ("z", new JsonNumber (v.z));

					claimsJson.Add (claim);
				}
			}

			WebUtils.WriteJson (_context.Response, result);
		}
	}
}