using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetPlayersLocation : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			AdminTools admTools = GameManager.Instance.adminTools;
			PlatformUserIdentifierAbs reqUserId = _context.Connection?.UserId;

			bool listOffline = false;
			if (_context.Request.QueryString ["offline"] != null) {
				bool.TryParse (_context.Request.QueryString ["offline"], out listOffline);
			}

			bool bViewAll = WebConnection.CanViewAllPlayers (_context.PermissionLevel);

			JsonArray playersJsResult = new JsonArray ();

			Players playersList = PersistentContainer.Instance.Players;

			foreach ((PlatformUserIdentifierAbs userId, Player player) in playersList.Dict) {
				if (admTools != null) {
					if (admTools.IsBanned (userId, out _, out _)) {
						continue;
					}
				}

				if (!listOffline && !player.IsOnline) {
					continue;
				}

				if (!bViewAll && !player.PlatformId.Equals (reqUserId)) {
					continue;
				}

				JsonObject pos = new JsonObject ();
				pos.Add ("x", new JsonNumber (player.LastPosition.x));
				pos.Add ("y", new JsonNumber (player.LastPosition.y));
				pos.Add ("z", new JsonNumber (player.LastPosition.z));

				JsonObject pJson = new JsonObject ();
				pJson.Add ("steamid", new JsonString (userId.CombinedString));

				//					pJson.Add("entityid", new JSONNumber (p.EntityID));
				//                    pJson.Add("ip", new JSONString (p.IP));
				pJson.Add ("name", new JsonString (player.Name));
				pJson.Add ("online", new JsonBoolean (player.IsOnline));
				pJson.Add ("position", pos);

				//					pJson.Add ("totalplaytime", new JSONNumber (p.TotalPlayTime));
				//					pJson.Add ("lastonline", new JSONString (p.LastOnline.ToString ("s")));
				//					pJson.Add ("ping", new JSONNumber (p.IsOnline ? p.ClientInfo.ping : -1));

				playersJsResult.Add (pJson);
			}

			WebUtils.WriteJson (_context.Response, playersJsResult);
		}
	}
}