using System;
using AllocsFixes.JSON;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetServerInfo : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			JsonObject serverInfo = new JsonObject ();

			GameServerInfo gsi = ConnectionManager.Instance.LocalServerInfo;

			foreach (string stringGamePref in Enum.GetNames (typeof (GameInfoString))) {
				string value = gsi.GetValue ((GameInfoString) Enum.Parse (typeof (GameInfoString), stringGamePref));

				JsonObject singleStat = new JsonObject ();
				singleStat.Add ("type", new JsonString ("string"));
				singleStat.Add ("value", new JsonString (value));

				serverInfo.Add (stringGamePref, singleStat);
			}

			foreach (string intGamePref in Enum.GetNames (typeof (GameInfoInt))) {
				int value = gsi.GetValue ((GameInfoInt) Enum.Parse (typeof (GameInfoInt), intGamePref));

				JsonObject singleStat = new JsonObject ();
				singleStat.Add ("type", new JsonString ("int"));
				singleStat.Add ("value", new JsonNumber (value));

				serverInfo.Add (intGamePref, singleStat);
			}

			foreach (string boolGamePref in Enum.GetNames (typeof (GameInfoBool))) {
				bool value = gsi.GetValue ((GameInfoBool) Enum.Parse (typeof (GameInfoBool), boolGamePref));

				JsonObject singleStat = new JsonObject ();
				singleStat.Add ("type", new JsonString ("bool"));
				singleStat.Add ("value", new JsonBoolean (value));

				serverInfo.Add (boolGamePref, singleStat);
			}


			WebUtils.WriteJson (_context.Response, serverInfo);
		}
	}
}