using System.IO;
using AllocsFixes.FileCache;
using Webserver.UrlHandlers;

namespace Webserver {
	public class WebMod {
		private const string modsBaseUrl = "/webmods/";
		private const string reactBundleName = "bundle.js";
		private const string stylingFileName = "styling.css";
		
		public readonly Mod ParentMod;
		public readonly string ReactBundle; // Absolute web path to the React bundle if the mod has one, e.g. "/webmods/myMod/bundle.js"
		public readonly string CssPath; // Absolute web path to a CSS if the mod has one, e.g. "/webmods/myMod/styling.css";

		public WebMod (Web _parentWeb, Mod _parentMod, bool _useStaticCache) {
			string folder = _parentMod.Path + "/WebMod";
			if (!Directory.Exists (folder)) {
				throw new InvalidDataException("No WebMod folder in mod");
			}

			string urlWebModBase = $"{modsBaseUrl}{_parentMod.FolderName}/";

			ReactBundle = folder + "/" + reactBundleName;
			if (File.Exists (ReactBundle)) {
				ReactBundle = urlWebModBase + reactBundleName;
			} else {
				ReactBundle = null;
			}

			CssPath = folder + "/" + stylingFileName;
			if (File.Exists (CssPath)) {
				CssPath = urlWebModBase + stylingFileName;
			} else {
				CssPath = null;
			}

			if (ReactBundle == null && CssPath == null) {
				throw new InvalidDataException($"WebMod folder has neither a {reactBundleName} nor a {stylingFileName}");
			}

			ParentMod = _parentMod;

			_parentWeb.RegisterPathHandler (urlWebModBase, new StaticHandler (
				folder,
				_useStaticCache ? (AbstractCache) new SimpleCache () : new DirectAccess (),
				false)
			);
		}
	}
}