using System.Collections.Generic;
using JetBrains.Annotations;

namespace Webserver.Commands {
	[UsedImplicitly]
	public class ReloadWebPermissions : ConsoleCmdAbstract {
		public override string GetDescription () {
			return "force reload of web permissions file";
		}

		public override string[] GetCommands () {
			return new[] {"reloadwebpermissions"};
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			WebPermissions.Instance.Load ();
			SdtdConsole.Instance.Output ("Web permissions file reloaded");
		}
	}
}