using System;
using System.Net;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class ExecuteConsoleCommand : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			if (string.IsNullOrEmpty (_context.Request.QueryString ["command"])) {
				WebUtils.WriteText (_context.Response, "No command given", HttpStatusCode.BadRequest);
				return;
			}

			WebCommandResult.ResultType responseType = WebCommandResult.ResultType.Full;

			string formatArg = _context.Request.QueryString ["format"];
			if (formatArg != null) {
				if (formatArg.EqualsCaseInsensitive ("raw")) {
					responseType = WebCommandResult.ResultType.Raw;
				} else if (formatArg.EqualsCaseInsensitive ("simple")) {
					responseType = WebCommandResult.ResultType.ResultOnly;
				}
			}
			
			string commandline = _context.Request.QueryString ["command"];
			string commandPart = commandline.Split (' ') [0];
			string argumentsPart = commandline.Substring (Math.Min (commandline.Length, commandPart.Length + 1));

			IConsoleCommand command = SdtdConsole.Instance.GetCommand (commandline);

			if (command == null) {
				WebUtils.WriteText (_context.Response, "Unknown command", HttpStatusCode.NotFound);
				return;
			}

			int commandPermissionLevel = GameManager.Instance.adminTools.GetCommandPermissionLevel (command.GetCommands ());

			if (_context.PermissionLevel > commandPermissionLevel) {
				WebUtils.WriteText (_context.Response, "You are not allowed to execute this command", HttpStatusCode.Forbidden);
				return;
			}

			_context.Response.SendChunked = true;
			WebCommandResult wcr = new WebCommandResult (commandPart, argumentsPart, responseType, _context.Response);
			SdtdConsole.Instance.ExecuteAsync (commandline, wcr);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}