using System;
using System.Collections.Generic;
using AllocsFixes.PersistentData;

namespace AllocsFixes {
	public static class LandClaimList {
		public delegate bool OwnerFilter (Player _owner);

		public delegate bool PositionFilter (Vector3i _position);

		public static Dictionary<Player, List<Vector3i>> GetLandClaims (OwnerFilter[] _ownerFilters,
			PositionFilter[] _positionFilters) {
			Dictionary<Vector3i, PersistentPlayerData> d = GameManager.Instance.GetPersistentPlayerList ().m_lpBlockMap;
			Dictionary<Player, List<Vector3i>> result = new Dictionary<Player, List<Vector3i>> ();

			if (d == null) {
				return result;
			}

			Dictionary<PersistentPlayerData, List<Vector3i>> owners =
				new Dictionary<PersistentPlayerData, List<Vector3i>> ();
			foreach ((Vector3i claimPos, PersistentPlayerData owner) in d) {
				bool allowed = true;
				if (_positionFilters != null) {
					foreach (PositionFilter pf in _positionFilters) {
						if (pf (claimPos)) {
							continue;
						}

						allowed = false;
						break;
					}
				}

				if (!allowed) {
					continue;
				}

				if (!owners.ContainsKey (owner)) {
					owners.Add (owner, new List<Vector3i> ());
				}

				owners [owner].Add (claimPos);
			}

			foreach ((PersistentPlayerData owner, List<Vector3i> claimPositions) in owners) {
				Player p = PersistentContainer.Instance.Players [owner.UserIdentifier, false] ?? new Player (owner.UserIdentifier);

				bool allowed = true;
				if (_ownerFilters != null) {
					foreach (OwnerFilter of in _ownerFilters) {
						if (of (p)) {
							continue;
						}

						allowed = false;
						break;
					}
				}

				if (!allowed) {
					continue;
				}

				result.Add (p, new List<Vector3i> ());
				foreach (Vector3i v in claimPositions) {
					result [p].Add (v);
				}
			}

			return result;
		}

		public static OwnerFilter UserIdFilter (PlatformUserIdentifierAbs _userId) {
			return _p => _p.PlatformId.Equals (_userId);
		}

		public static PositionFilter CloseToFilter2dRect (Vector3i _position, int _maxDistance) {
			return _v => Math.Abs (_v.x - _position.x) <= _maxDistance && Math.Abs (_v.z - _position.z) <= _maxDistance;
		}

		public static OwnerFilter OrOwnerFilter (OwnerFilter _f1, OwnerFilter _f2) {
			return _p => _f1 (_p) || _f2 (_p);
		}
	}
}