using System.Collections.Generic;
using JetBrains.Annotations;

namespace MapRendering.Commands {
	[UsedImplicitly]
	public class RenderMap : ConsoleCmdAbstract {
		public override string GetDescription () {
			return "render the current map to a file";
		}

		public override string[] GetCommands () {
			return new[] {"rendermap"};
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			MapRenderer.Instance.RenderFullMap ();

			SdtdConsole.Instance.Output ("Render map done");
		}
	}
}