using System;
using System.Collections.Generic;
using System.Net;
using Platform.Steam;

namespace Webserver {
	public class ConnectionHandler {
		private readonly Dictionary<string, WebConnection> connections = new Dictionary<string, WebConnection> ();

		public WebConnection IsLoggedIn (string _sessionId, IPAddress _ip) {
			if (!connections.TryGetValue (_sessionId, out WebConnection con)) {
				return null;
			}

//			if (con.Age.TotalMinutes > parent.sessionTimeoutMinutes) {
//				connections.Remove (_sessionId);
//				return null;
//			}

			if (!Equals (con.Endpoint, _ip)) {
				// Fixed: Allow different clients from same NAT network
//				connections.Remove (_sessionId);
				return null;
			}

			con.UpdateUsage ();

			return con;
		}

		public void LogOut (string _sessionId) {
			connections.Remove (_sessionId);
		}

		public WebConnection LogIn (ulong _steamId, IPAddress _ip) {
			string sessionId = Guid.NewGuid ().ToString ();
			PlatformUserIdentifierAbs userId = new UserIdentifierSteam (_steamId);
			WebConnection con = new WebConnection (sessionId, _ip, userId);
			connections.Add (sessionId, con);
			return con;
		}

		public void SendLine (string _line) {
			foreach (KeyValuePair<string, WebConnection> kvp in connections) {
				kvp.Value.SendLine (_line);
			}
		}
	}
}